﻿#include <iostream>
#include <vector>
#include <numeric>
#include <algorithm>
#include <stack>
#include <queue>
#include <set>
#include <unordered_set>
#include <map>
#include <unordered_map>
#include <cassert>
#include <bitset>
#include <cmath>
#include <string>

#pragma GCC optimize("O3,unroll-loops")
// #pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")

using namespace std;

using ll = long long;
using ld = long double;

const int INT_INF = 2e9 + 10;
const ll LL_INF = 2e18 + 10;

const int MOD = 1e9 + 7;

template<typename T> istream& operator >> (istream& in, vector<T>& a) {
	for (auto& i : a) {
		in >> i;
	}
	return in;
}

bool is_palindrome(int a) {
	if (a < 10) {
		return true;
	}
	if (a < 100) {
		return a % 10 == a / 10;
	}
	return a / 100 == a % 10;
}

int main() {
	vector<int> pals;
	int MAXN = 1001;
	vector<int> dp(MAXN, INT_INF);
	for (int i = 1; i < MAXN; i++) {
		if (is_palindrome(i)) {
			pals.push_back(i);
			dp[i] = 1;
		}
		else {
			for (auto& j : pals) {
				dp[i] = min(dp[i], dp[i - j] + 1);
			}
		}
	}
	int t;
	cin >> t;
	while (t--) {
		int a;
		cin >> a;
		cout << dp[a] << '\n';
	}
}
